﻿#using System.Threading.Tasks;
#using Tessa.Cards;

const string justificationAlias = "ExJustification";
const string commentAlias = "Comment";

const string bSend = "Send";
const string mCardFileCategoryName = "Финансовое обоснование";

if(Dialog.ButtonName == bSend)
{
	(await this.GetCardObjectAsync()).Sections.GetOrAdd(justificationAlias).Fields[commentAlias] = (await Dialog.GetDialogCardAsync(this.CancellationToken)).Sections[justificationAlias].Fields[commentAlias];

	var mCardFileContainer = (await this.KrScope.GetMainCardFileContainerAsync(CardID)).FileContainer;
	var dCardFileContainer = (await Dialog.GetFileContainerAsync(cancellationToken: this.CancellationToken)).FileContainer;
	
	foreach(var dFile in dCardFileContainer.Files)
	{
		if(!dFile.Content.HasData)
		{
			ValidationResult result = await dFile.EnsureContentDownloadedInUIAsync(cancellationToken: this.CancellationToken);
			ValidationResult.Add(result);
			if(result.HasErrors)
			{
				return;
			}
		}
		
		await mCardFileContainer
			.BuildFile(dFile.Name)
			.SetContent(dFile.Content)
			.SetVersionToken(
				(ft, ct) =>
				{
					var lastVersion = dFile.Versions.Last();
					
					ft.Created = lastVersion.Created;
					ft.CreatedByID = lastVersion.CreatedByID;
					ft.CreatedByName = lastVersion.CreatedByName;
					
					ft.Hash = lastVersion.Hash;
					
					return new ValueTask();
				})
			.SetCategory(mCardFileCategoryName)
			.AddWithNotificationAsync(cancellationToken: this.CancellationToken);
	}
}